# Minimal App Starter Kit

**A foundation for building single-user web applications.** This note-taking app is a working example you can adapt for any simple app idea - todo lists, habit trackers, personal dashboards, or anything else. Just modify the UI and reuse the backend.

Zero build process. Just HTML, jQuery, Tailwind CSS (via CDN), and a tiny Express backend that reads/writes a JSON file.

## Quick Start

```bash
npm install
npm run dev
# Open http://localhost:3000
```

## Structure

```
minimal-app/
├── index.html    # Frontend (all UI + JavaScript in one file)
├── server.js     # Backend (serves HTML + 2 API endpoints)
├── db.json       # Database (just a JSON file)
├── deploy.sh     # One-click deployment script
└── package.json  # Single dependency: express
```

## How It Works

### The Flow

1. **Browser loads** `http://localhost:3000` → Express serves `index.html`
2. **Page loads** → jQuery fetches `GET /api/notes` → Gets entire JSON from `db.json`
3. **User adds note** → jQuery sends `POST /api/notes` with full notes array → Overwrites `db.json`
4. **User deletes note** → jQuery filters array, sends `POST /api/notes` → Overwrites `db.json`

### Frontend (`index.html`)

Single HTML file with embedded JavaScript:
- **Tailwind CSS** via CDN for styling
- **jQuery** via CDN for DOM manipulation
- Manages notes array in memory
- Renders table from array
- Sends entire array to backend on every change

### Backend (`server.js`)

Minimal Express server (42 lines):
- `GET /` → Serves `index.html`
- `GET /api/notes` → Reads `db.json`, returns entire content
- `POST /api/notes` → Receives complete notes array, overwrites `db.json`

### API Design

**Read:** `GET /api/notes`
```json
{ "notes": [{"id": 1, "label": "Todo", "status": "pending", "text": "Buy milk"}] }
```

**Write:** `POST /api/notes`
```javascript
// Send complete data - replaces entire file
{ "notes": [...allNotes] }
```

The API always works with the **complete dataset**. No partial updates, no complex logic - just read all or write all.

### Database (`db.json`)

Simple JSON file that stores the complete application state:
```json
{
  "notes": [
    {"id": 1, "label": "Todo", "status": "pending", "text": "Buy milk", "created": "2024-01-01T00:00:00.000Z"}
  ]
}
```

## Deployment

See [DEPLOYMENT.md](DEPLOYMENT.md) for instructions on deploying to DigitalOcean.

---

That's it. A complete web app in ~250 lines total. No webpack, no build steps, no complexity.